function ajax_cart(obj, id, positive, text, remove = false) {
  Progress();
  let cart = document.querySelectorAll('.cart_');
  let sizing = document.querySelector('#sizing label input[name=size_]:checked');
  let coloring = document.querySelector('#coloring label input[name=color_]:checked');
  if (sizing) {
    size = sizing.value;
  } else {
    size = null;
  }
  if (coloring) {
    color = coloring.value;
  } else {
    color = null;
  }
  const data = { positive: positive, remove: remove, size: size, color: color }
  $.ajax({
    type: "GET",
    url: "/cart/add_to_cart/" + id + "",
    data: data,
    success: function (response) {
      Progress(false);
      if (response != 'false') {
        if (text) {
          //obj.setAttribute("is_notif", "");
          document.getElementsByClassName('cart_notif')[0].innerHTML = response.count;
          obj.innerHTML = response.p_count + ' عدد در سبد خرید';
        } else {
          if (Number(response.count) < 1 || remove == true) {
            obj.parentElement.parentElement.parentElement.parentElement.remove();
            if (document.querySelectorAll('.shopping__cart__row').length < 1) {
              history.back()
            }
            // window.location.href = "/";
          } else {
            if (document.getElementsByClassName('add_to_cart')[0]) {
              document.getElementsByClassName('cart_notif')[0].innerHTML = response.count;
              document.getElementsByClassName('add_to_cart')[0].innerHTML = 'به سبد خرید شما اضافه شد'
            } else {
              console.log('here')
              obj.parentElement.children[1].value = response.p_count;
            }
          }

        }

        if (cart[0]) {
          if (cart[0].hasAttribute('href')) {

          } else {
            cart[0].href = "/cart/";
          }
        }
        if (cart[0] && cart[0].hasAttribute('aria-label')) {
          cart[0].removeAttribute("aria-label");
          cart[0].removeAttribute("data-balloon-pos");
        }
      } else {
        am_warning(1, 'ابتدا در سایت ثبت نام کنید', '/accounts/login/')
      }
    },
    error: function (response) {
      Progress(false);
      am_warning(1, 'مشکلی پیش آمده!')
    },
  });
}

function Cart(obj, id, add = true, remove = false) {
  Progress();
  let cart = document.querySelectorAll('.cart_');
  let sizing = document.getElementById('sizing');
  let coloring = document.getElementById('coloring');
  if (sizing) {
    size = sizing.value;
  } else {
    size = null;
  }
  if (coloring) {
    color = coloring.value;
  } else {
    color = null;
  }
  let data_ = getCookie('product');
  console.log(data_, '0');
  // if data(product in cart) already exist
  if (data_) {
    let data = JSON.parse(data_);
    if (remove) {
      for (var i = 0; i < data.length; i++) {
        if (data[i]['product'] == id) {
          data.splice(i, 1);
          obj.parentElement.remove();
        }
      }
      document.cookie = "product=" + JSON.stringify(data) + ";path=/;";
      Progress(false);
      if (document.querySelectorAll('.product__cart__item').length < 1) {
        history.back()
      }
    } else {
      var price = false
      // check if contains fa-plus || fa-minus in classlist get price
      if (obj.classList.contains('fa-plus') || obj.classList.contains('fa-minus')) {
        price = obj.parentElement.parentElement.parentElement.querySelector('.real_price');
      }
      // add product ++
      if (add) {
        let new_ = true;
        for (var i = 0; i < data.length; i++) {
          if (data[i]['product'] == id) {
            new_ = false;
            data[i]['count'] += 1;
            if (price) {
              obj.parentElement.children[1].value = data[i]['count'];
              price.innerHTML = ToRial((price_to_number(price.innerHTML) / (data[i]['count'] - 1)) * data[i]['count']);
              var cart_total_ = document.querySelectorAll('.cart__price span');
              var total_ = 0;
              for (var i = 0; i < cart_total_.length; i++) {
                total_ += Number(cart_total_[i].innerHTML);
              }
              document.getElementById('cart__total').innerHTML = ToRial(total_);
            }
          }
        }
        // if product is new in cart list
        if (new_) {
          const dict = { product: id, count: 1, desc: { color: coloring ? color : '', size: sizing ? size : '' } };
          data.push(dict);
        }
        document.cookie = "product=" + JSON.stringify(data) + ";path=/;";
        Progress(false);
      } else {
        // minus product --
        for (var i = 0; i < data.length; i++) {
          if (data[i]['product'] == id) {
            if (data[i]['count'] > 1) {
              data[i]['count'] -= 1;
              if (price) {
                obj.parentElement.children[1].value = data[i]['count'];
                price.innerHTML = ToRial((price_to_number(price.innerHTML) / (data[i]['count'] + 1)) * data[i]['count']);
                var cart_total_ = document.querySelectorAll('.cart__price span');
                var total_ = 0;
                for (var i = 0; i < cart_total_.length; i++) {
                  total_ += Number(cart_total_[i].innerHTML);
                }
                document.getElementById('cart__total').innerHTML = total_;
              }
            } else {
              data.splice(i, 1);
              obj.parentElement.parentElement.parentElement.parentElement.remove();
            }
          }
        }
        document.cookie = "product=" + JSON.stringify(data) + ";path=/;";
        Progress(false);
      }
    }
    if (data.length < 1) {
      document.cookie = "product=;path=/;expires=Thu, 01 Jan 1970 00:00:01 GMT;";
      obj.parentElement.remove();
      Progress(false);
      history.back()
    }
  } else {
    const list = [];
    const dict = { product: id, count: 1, desc: { color: coloring ? color : '', size: sizing ? size : '' } };
    list.push(dict);
    document.cookie = "product=" + JSON.stringify(list) + ";path=/;";
    Progress(false);
  }
  // add to header cart notif
  var cookie_data = getCookie('product');
  if (cookie_data) {
    var data_count = JSON.parse(cookie_data);
  }
  document.getElementsByClassName('cart_notif')[0].innerHTML = cookie_data ? data_count.length : 0;
  document.getElementsByClassName('cart_notif')[1].innerHTML = cookie_data ? data_count.length : 0;
  // change text of: __________ "افزودن به سبد" => "به سبد خریدتان اضافه شد"
  if (obj.children.length > 0) {
    if (obj.children[0].classList.contains('fa-shopping-bag')) {
      //obj.setAttribute("is_notif", "");
    }
  }
  if (obj.classList.contains('shop_cart')) {
    obj.innerHTML = 'به سبد خریدتان اضافه شد'
  }
  if (obj.classList.contains('add_to_cart')) {
    obj.innerHTML = 'به سبد خریدتان اضافه شد'
  }
  // set link for cart icon => header and sticky header
  if (cart[0]) {
    if (cart[0].hasAttribute('href')) {
      
    } else {
      cart[0].removeAttribute("aria-label");
      cart[0].removeAttribute("data-balloon-pos");
      cart[0].href = "/cart/";
      cart[1].removeAttribute("aria-label");
      cart[1].removeAttribute("data-balloon-pos");
      cart[1].href = "/cart/";
    }
  }
}
// cart ---------- size _ color
function Add_info_to_cart(id) {
  Progress();
  let sizing = document.getElementById('sizing' + id);
  let coloring = document.getElementById('coloring' + id);
  if (sizing) {
    size = sizing.value;
  } else {
    size = null;
  }
  if (coloring) {
    color = coloring.value;
  } else {
    color = null;
  }
  data = { size: size, color: color }
  $.ajax({
    type: "get",
    url: "/cart/add_info_to_cart/" + id,
    data: data,
    success: function (response) {
      Progress(false);
      //window.location.href = response;
    },
    error: function () {
      Progress(false);
      am_warning(1, 'احتمالا این آدرس قدیمی است و محصول به سفارش های شما انتقال پیدا کرده اگر چنین نبود به ما اطلاع دهید', '/accounts/user/')
    },
  });
}

// cookie cart ---------- size _ color
function add_info_to_cookie(id, size = null, color = null) {
  Progress();
  let data_ = getCookie('product');
  if (data_) {
    let data = JSON.parse(data_);
    for (var i = 0; i < data.length; i++) {
      if (data[i]['product'] == id) {
        if (size) {
          data[i]['desc']['size'] = size;
        }
        if (color) {
          data[i]['desc']['color'] = color;
        }
        document.cookie = "product=" + JSON.stringify(data) + ";path=/;";
        Progress(false);
      }
    }
  }
}

function price_to_number(price) {
  price = price.split(",");
  let without_digit = '';
  for (let i = 0; i < price.length; i++) {
    without_digit += price[i];
  }
  return Number(without_digit)
}

function getCookie(cname) {
  let name = cname + "=";
  let decodedCookie = decodeURIComponent(document.cookie);
  let ca = decodedCookie.split(';');
  for (let i = 0; i < ca.length; i++) {
    let c = ca[i];
    while (c.charAt(0) == ' ') {
      c = c.substring(1);
    }
    if (c.indexOf(name) == 0) {
      return c.substring(name.length, c.length);
    }
  }
  return "";
}